﻿var drillDownOptions = [];

$(document).on("pageinit", function () {    
    $("[data-questiontype='drilldown']").each(function () {
        var drilldown = $(this);

        //Check if first dropdown is answered
        var answered = $("select:first", drilldown).val();

        // Omit first drilldown since options are always visible
        $("select:gt(0)", drilldown).each(function () {
            var select = $(this);
            var dropDownName = select.attr("name");

            _.each($("option[data-parent]", select), function (opt) {
                var parent = $(opt).attr("data-parent");
                drillDownOptions.push({ dropDown: dropDownName, parent: parent, id: $(opt).attr("id"), value: $(opt).val(), text: $(opt).text().trim() });

                if (!answered || (parent && answered != parent))
                    $(opt).detach();
            });

            answered = select.val();

            select.selectmenu("refresh");
        });
    });

    $("[data-questiontype='dropdownlist'] select").on("change", function () {
        var choice = $(this).find(":selected");
        ToggleOpenEndMobile(choice, true);
    });

    $("[data-questiontype='drilldown'] select").on("change", function () {
        var choice = $(this).find(":selected");
        var choiceList = $(this).closest(".ui-select");
        var choiceLists = choiceList.nextAll("div.ui-select");

        ToggleOpenEndMobile(choice, true);

        if (choiceLists.length > 0) {
            choiceLists.each(function () {
                $(this).find("select option[value!='']").detach();
            });

            var next = choiceLists.first();
            var dropDownName = $("select", next).attr("name");

            $("select option:selected", choiceList).each(function (i, selected) {
                _.each(_.filter(drillDownOptions, function (c) { return c.dropDown == dropDownName && (c.parent == $(selected).val() || c.parent == ""); }), function (c) {
                    $("select", next).append($('<option>', { value: c.value }).text(c.text).attr("data-parent", c.parent).attr("id", c.id)).selectmenu("refresh");
                });
            });

            $("select", choiceLists).selectmenu("refresh");
        }
    });
});
